		function [G, Z, P, dopt] = POLE_PLACER_LP_MF_S(Amax, Wc, Amin, wstep, wi, NIN)
		
		%	Returns the zeros, poles and scaling constant for a lowpass filter with
		%	a maximally flat passband.
		%	dopt is the final distance to the specification in dB. 
		%	If the specification is not met then Dopt < 0.
		%	The routine uses the tranformed variable Z to achieve higher numerical accuracy.
		%	Amax = passband ripple in dB
		%	Wc = passband cutoff angular frequency
		%	Amin = contains piecewise constant stopband attenuation 
		%	wstep = edge frequencies in the stopband
		%	wi = initial frequencies of the zeros on the imaginary axis
		%	NIN = number of zeros at infinity
		%	wstep and wi may NOT contain any common values.
		
		% Toolbox for ANALOG FILTERS USING MATLAB, Springer, 2009
		
		%	Author: 		Per Lvenborg 1999-03-22
		%	Modified by: 	LW, 2007-12-14, 2011-01-23
		%	Copyright:		by authors - not released for commercial use
		%	Version 		1
		%	Known bugs: 	May not always converge, try another initial placement
		%	Report bugs to:	Wanhammar@gmail.com
		
		
		zatt = lp_w2z(wi, Wc);
		zstep = lp_w2z(wstep, Wc);		
		if min(wi) < min(wstep)
			disp('Error: Initial attenuation poles not in stop band.')
			return;
		end
		zstep = sort(zstep);
		while 1
			zatt = sort(zatt);
			zarcmin = lp_find_arcmin_mf(zatt, NIN);
			[dmin, zout] = lp_find_dmin3(zstep, zatt, zarcmin, Amin, Amax, NIN);
			[deltaz, dopt] = lp_find_new_poles(zatt, NIN, Amax, zout, dmin);
			if isempty(deltaz)
				break;
			end
			zatt = zatt+deltaz;
			for k = 1:length(zatt)
				if zatt(k) <= zstep(1)
					zatt(k) = zstep(1)+rand(1)/100;
				elseif zatt(k) > 1
					zatt(k) = 1-rand(1)/100;    
				end
			end
			if max(abs(deltaz)) < 1e-11
				%	dopt
				break;
			else
				%	disp(mean(deltaz))
			end
		end
		ee = lpmf_get_ee(zatt, NIN, Amax); % ee =f^2 + q^2
		[P, Q] = bairstow(ee);
		wi = lp_z2w(zatt, Wc);
		[P, G] = lp_get_poles(P, Q, Wc, Amax, wi);
		Z = [j*wi -j*wi]';
		P = P';
		G = real(G);
		
		
